//#region 页面加载执行---start----
var zcell_1;
var zcell_2; //多实例测试用
var zcell_3; //多实例测试用
let sheet_1;

//页面加载时执行
window.onload = function () {
  //初始化ZCELL
  initzcell();

  //API测试初始化
  initAPItest();

  //设置自定义右键菜单
  sheet_1.BindEvents("CustomContextMenu", "", function (e) {
    setmenu(e);
  });

  //隐藏右键菜单
  $(document).click(function () {
    $(".contextmenu").hide();
  });
};

// 初始化ZCELL
function initzcell() {
  var options = {
    container: document.getElementById("zcell-container"),
  };

  zcell_1 = new ZCell.WorkBook(options);
}

//自定义右键菜单
function setmenu(e) {
  //Get window size:
  var winWidth = $(document).width();
  var winHeight = $(document).height();
  //Get pointer position:
  var posX = e.pageX;
  var posY = e.pageY;
  //Get contextmenu size:
  var menuWidth = $(".contextmenu").width();
  var menuHeight = $(".contextmenu").height();
  //Security margin:
  var secMargin = 10;
  //Prevent page overflow:
  if (
    posX + menuWidth + secMargin >= winWidth &&
    posY + menuHeight + secMargin >= winHeight
  ) {
    //Case 1: right-bottom overflow:
    posLeft = posX - menuWidth - secMargin + "px";
    posTop = posY - menuHeight - secMargin + "px";
  } else if (posX + menuWidth + secMargin >= winWidth) {
    //Case 2: right overflow:
    posLeft = posX - menuWidth - secMargin + "px";
    posTop = posY + secMargin + "px";
  } else if (posY + menuHeight + secMargin >= winHeight) {
    //Case 3: bottom overflow:
    posLeft = posX + secMargin + "px";
    posTop = posY - menuHeight - secMargin + "px";
  } else {
    //Case 4: default values:
    posLeft = posX + secMargin + "px";
    posTop = posY + secMargin + "px";
  }

  //显示菜单
  $(".contextmenu")
    .css({
      left: posLeft,
      top: posTop,
    })
    .show();
}

//执行右键菜单事件
function execmenu(item) {
  if (item == "merge") {
    //合并选定的单元格
    //获得选中单元格json
    var str = sheet_1.GetSelCellsJson(); //{cells:[{row:22,col:4}]}

    var jsondata = eval("(" + str + ")");

    var c = jsondata.cells;
    sheet_1.MergeCell(
      c[0].row,
      c[0].col,
      c[c.length - 1].row,
      c[c.length - 1].col
    ); //合并选定的单元格
    //移动选中合并后单元格
    sheet_1.MoveToCell(c[0].row, c[0].col);
  } else if (item == "unmerge") {
    //拆分单元格
    //获得选中单元格json
    var str = sheet_1.GetSelCellsJson();
    var jsondata = $.parseJSON(str);
    var c = jsondata.cells;
    //遍历
    for (var i = 0, l = c.length; i < l; i++) {
      if (sheet_1.GetCellIsMerge(c[i].row, c[i].col)) {
        //是合并单元格
        sheet_1.SplitCell(c[i].row, c[i].col);
      }
    }
  } else if (item == "insertrow") {
    let cell = sheet_1.activedCell;
    sheet_1.InsertRow(cell.row, 1);
  } else if (item == "insertcol") {
    let cell = sheet_1.activedCell;
    sheet_1.InsertCol(cell.col, 1);
  } else if (item == "deleterow") {
    let cell = sheet_1.activedCell;
    sheet_1.DeleteRow(cell.row, 1);
  } else if (item == "deletecol") {
    let cell = sheet_1.activedCell;
    sheet_1.DeleteCol(cell.col, 1);
  } else if (item == "自动换行") {
    let cell = sheet_1.activedCell;

    var style1 = { wordWrap: 1 };
    sheet_1.SetCellStyle(cell.row, cell.col, style1);
  } else if (item == "查看单元格") {
    let cell = sheet_1.activedCell;
    console.log(cell);
    console.log(sheet_1.datasourceList);

    alert("请通过控制台查看输出信息");
  } else if (item == "隐藏列") {
    let cell = sheet_1.activedCell;
    let colno = cell.col;
    sheet_1.SetColHidden(colno, colno); //设置隐藏
  } else if (item == "隐藏行") {
    let cell = sheet_1.activedCell;
    let rowno = cell.row;
    sheet_1.SetRowHidden(rowno, rowno); //设置隐藏
  } else {
    alert(item);
  }
}

//加载多页签
function refreshTab(zc) {
  if (zc == null) zc = zcell;
  let tab_head = document.getElementsByClassName("tab-head")[0];
  $(tab_head).html("");
  let listr = "";

  for (let index = 0; index < zc.sheets.length; index++) {
    if (zc.sheets[index] == zc.activedSheet) {
      listr +=
        '<li class="tabselected" onclick="showTab(`{0}`)" >{1}</li>'.format(
          zc.sheets[index].name,
          zc.sheets[index].name
        );
      sheet_1 = zc.sheets[index];
    } else {
      listr +=
        '<li class="tabnoselected" onclick="showTab(`{0}`)" >{1}</li>'.format(
          zc.sheets[index].name,
          zc.sheets[index].name
        );
    }
  }
  $(tab_head).append(listr);

  let tabs = document
    .getElementsByClassName("tab-head")[0]
    .getElementsByTagName("li");
}

//实现多页签
function showTab(sheetname) {
  let tabs = document
    .getElementsByClassName("tab-head")[0]
    .getElementsByTagName("li");
  for (var i = 0, len = tabs.length; i < len; i++) {
    let name = $(tabs[i]).text();

    if (name === sheetname) {
      tabs[i].className = "tabselected";
      sheet_1 = zcell_1.GetSheetByName(sheetname);
      zcell_1.SelectSheet(sheet_1);
    } else {
      tabs[i].className = "tabnoselected";
    }
  }
}

//#endregion 页面加载执行---end----

//#region API测试初始化---start----
//API测试初始化
function initAPItest() {
  //先清空所有sheet
  zcell_1.DeleteAllSheet();

  //初始化homesheet
  inithomesheet();

  sheet_1.SuspendPaint(); //挂起绘制

  //#region--前两行链接设置--start--

  //合并单元格
  sheet_1.MergeCell(0, 1, 0, 10);
  //设置样式，字体、颜色等
  sheet_1.SetCellStyle("B1", {
    fontColor: "#FF0000",
    hAlign: "center",
  });

  //设置值
  sheet_1.SetCellValue(
    0,
    1,
    "本版是智表(ZCELL)专业版，是更加专业的前端仿Excel插件，欢迎体验。如果您需要智表专业版，请联系qq群755407212（加群注明“智表咨询”） "
  );

  //链接按钮--免费版
  var ctype_link = {
    code: "linkbutton",
    object: {
      text: "去看看→智表免费版演示",
      fun: function openurl(e, data) {
        window.open(
          "http://www.zcell.net/zcelldemo/free/demo-free.html",
          "_blank"
        ); //_self
      },
    },
  };
  sheet_1.SetCellType("B2", ctype_link);
  sheet_1.MergeCell(1, 1, 1, 3);
  sheet_1.SetCellStyle("B2", {
    fontColor: "#0000FF",
    hAlign: "center",
    fontUnderline: 1,
  });

  //链接按钮--官网
  var ctype_link2 = {
    code: "linkbutton",
    object: {
      text: "智表（ZCELL）官网",
      fun: function openurl(e, data) {
        window.open("http://www.zcell.net", "_blank"); //_self
      },
    },
  };
  sheet_1.SetCellType(1, 4, ctype_link2);
  sheet_1.MergeCell(1, "E", 1, "H");
  sheet_1.SetCellStyle(1, 4, {
    fontColor: "#0000FF",
    hAlign: "center",
    fontUnderline: 1,
  });

  //链接按钮--博客
  var ctype_link3 = {
    code: "linkbutton",
    object: {
      text: "智表博客",
      fun: function openurl(e, data) {
        window.open("http://www.cnblogs.com/devilzh", "_blank"); //_self
      },
    },
  };
  sheet_1.SetCellType(1, 8, ctype_link3);
  sheet_1.MergeCell(1, 8, 1, 10);
  sheet_1.SetCellStyle(1, 8, {
    fontColor: "#0000FF",
    hAlign: "center",
    fontUnderline: 1,
  });

  //#endregion--前两行链接设置--start--

  //#region--样式、边框设置--start--

  //设置单元格文本
  sheet_1.SetCellValue("A3", "下面请体验：");
  sheet_1.SetColWidth("A", "A", 120); //设置列宽
  //设置样式
  sheet_1.SetCellStyle(2, 0, {
    backColor: "#FFFF00",
    hAlign: "center",
    fontBold: 1, //字体粗细 1为设置，0为正常
    fontItalic: 1, //斜体 1为设置，0为正常
  });
  //支持样式参数如下：
  // var style1 = {
  // backColor: "#FFFF00",
  // fontFamily: "宋体", //字体
  // fontColor: "#FF0000", // 按照十六进制 如 黑色：#000000  白色：#FFFFFF 红色：#FF0000  绿色：#00FF00  蓝色：#0000FF    黄色#FFFF00 橙色#FFA500 紫色 #FF00FF   灰色 #808080
  // fontSize: 12, //字体大小 px
  // fontBold: 1, //字体粗细 1为设置，0为正常
  // fontItalic: 1, //斜体 1为设置，0为正常
  // fontDelline: 1, //删除线 1为设置，0为正常
  // fontUnderline: 1, //下划线 1为设置，0为正常

  //对齐
  // hAlign: "center", // left center right  横向对齐
  // vAlign: "middle", // middle top bottom  纵向对齐
  // wordWrap: 1, // 是否自动换行  1为设置，0为否
  // textdirec: 0, // 0 横向 1纵向  2倾斜
  // textRatote: 30, // 文字倾斜角度
  // cellPadding: 1, //内边距 1PX，单位为像素
  // zoomTextAdapt: 0, //缩小字体填充
  // };

  //标题
  sheet_1.SetCellValue(3, 0, "■边框");
  sheet_1.SetCellStyle(3, 0, {
    hAlign: "center",
    textdirec: 1, // 0 横向 1纵向  2倾斜
  });
  sheet_1.SetRowHeight(3, 3, 40); //设置行高

  //设置边框
  sheet_1.SetCellBorder("B4", {
    borderLeft: { color: "#000000", style: "thin" }, //左边框
    borderRight: { color: "#FF0000", style: "thin" }, //右边框
    borderTop: { color: "#FF0000", style: "thin" }, //上边框
    borderBottom: { color: "#000000", style: "thin" }, //下边框
  });

  sheet_1.SetCellBorder(3, 3, {
    borderLeft: { color: "#000000", style: "dashDot" }, //左边框
    borderRight: { color: "#FF0000", style: "dashDot" }, //右边框
    borderTop: { color: "#FF0000", style: "dashDot" }, //上边框
    borderBottom: { color: "#000000", style: "dashDot" }, //下边框
  });

  sheet_1.SetCellBorder(3, 5, {
    borderLeft: { color: "#000000", style: "mediumDashDotDot" }, //左边框
    borderRight: { color: "#FF0000", style: "thick" }, //右边框
    borderTop: { color: "#FF0000", style: "mediumDashDotDot" }, //上边框
    borderBottom: { color: "#000000", style: "thick" }, //下边框
  });

  sheet_1.SetCellBorder(3, 7, {
    borderLeft: { color: "#000000", style: "dashed" }, //左边框
    borderRight: { color: "#FF0000", style: "dashed" }, //右边框
    borderTop: { color: "#FF0000", style: "dashed" }, //上边框
    borderBottom: { color: "#000000", style: "dashed" }, //下边框
  });
  //支持边框类型如下：
  //thin 细实线; hair 细虚线; dotted 点线; dashed 划线; dashDot 一点一划线; dashDotDot  两点一划线;
  //medium 中实线; mediumDashed 中划线; mediumDashDot  中一点一划线; mediumDashDotDot 中两点一划线; thick 粗实线

  //#endregion--样式、边框设置--end--

  //#region--合并单元格--start-
  //标题
  sheet_1.SetCellValue(4, 0, "■合并单元格");
  sheet_1.SetCellStyle(4, 0, {
    hAlign: "center",
    textdirec: 2, // 0 横向 1纵向  2倾斜
    textRatote: 20, // 文字倾斜角度

    fontUnderline: 1, //下划线 1为设置，0为正常
  });
  sheet_1.MergeCell(4, 0, 5, 0);

  //合并单元格
  sheet_1.MergeCell(4, 1, 5, 1);
  sheet_1.SetCellValue(4, 1, "单位");
  sheet_1.SetCellStyle(4, 1, {
    hAlign: "center",
  });

  sheet_1.MergeCell(4, 2, 5, 2);
  sheet_1.SetCellValue(4, 2, "综合取值");
  sheet_1.SetCellStyle(4, 2, {
    hAlign: "center",
  });

  sheet_1.MergeCell(4, 3, 4, 8);
  sheet_1.SetCellValue(4, 3, "费用");
  sheet_1.SetCellStyle(4, 3, {
    hAlign: "center",
  });

  sheet_1.SetCellValue(5, 3, "机械费");
  sheet_1.SetCellStyle(5, 3, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(5, 4, "材料费");
  sheet_1.SetCellStyle(5, 4, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(5, 5, "人工费");
  sheet_1.SetCellStyle(5, 5, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(5, 6, "其他费1");
  sheet_1.SetCellStyle(5, 6, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(5, 7, "其他费2");
  sheet_1.SetCellStyle(5, 7, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(5, 8, "其他费3");
  sheet_1.SetCellStyle(5, 8, {
    hAlign: "center",
  });

  sheet_1.MergeCell(4, 9, 4, 10);
  sheet_1.SetCellValue(4, 9, "请右键测试拆分合并");
  sheet_1.SetCellStyle(4, 9, {
    hAlign: "center",
    backColor: "#FFFF00",
  });

  //#endregion--合并单元格--start-

  //#region--公式计算--start-
  //标题
  sheet_1.SetCellValue(6, 0, "■公式计算");
  sheet_1.SetCellStyle(6, 0, {
    hAlign: "center",
    fontDelline: 1, //删除线 1为设置，0为正常
  });

  //设置原始值
  sheet_1.SetCellValue(7, 1, "分公司1");
  sheet_1.SetCellValue(7, 3, "300");
  sheet_1.SetCellValue(7, 4, "5.2375");
  sheet_1.SetCellValue(7, 5, "28.245");
  sheet_1.SetCellValue(7, 6, "-3.134");

  //批量设置格式
  sheet_1.SetCellFormat(["E8", "F8"], {
    code: "number",
    expression: { precision: "2" },
  });

  sheet_1.SetCellValue(8, 1, "分公司2");
  sheet_1.SetCellValue(8, 3, "600");
  sheet_1.SetCellValue(8, 4, "13.232");
  sheet_1.SetCellValue(8, 5, "58.14298");
  sheet_1.SetCellValue(8, 6, "83.8463");

  sheet_1.SetFormula("d7", "D8+D9");
  sheet_1.SetFormula(6, 4, "E8+E9");
  sheet_1.SetFormula(6, 5, "F8+F9");
  sheet_1.SetFormula(6, 6, "ABS(G8)+G9"); //支持直接使用公式函数，详细参考函数清单

  sheet_1.SetCellValue(6, 1, "合计值");
  sheet_1.SetFormula(6, 2, "SUM(D7:G7)*3-TEST1(1,2)"); // TEST1 为自定义函数，注意函数名、单元格名必须大写。

  //设置取消按钮
  var ctype_button1 = {
    code: "button",
    object: {
      text: "取消自动计算",
      fun: function test(e, data) {
        unautocalcu();
      },
    },
  };
  sheet_1.SetCellType(8, 9, ctype_button1);

  //设置重新计算按钮
  var ctype_button2 = {
    code: "button",
    object: {
      text: "重新计算",
      fun: function test(e, data) {
        manualcalcu();
      },
    },
  };
  sheet_1.SetCellType(8, 10, ctype_button2);

  //提示
  sheet_1.MergeCell(6, 9, 6, 10);
  sheet_1.SetCellValue(6, 9, "公式支持377项公式函数和自定义函数");
  sheet_1.SetCellStyle(6, 9, {
    hAlign: "center",
    backColor: "#FFFF00",
  });

  //#endregion--公式计算--end-

  //#region--数据格式--start-
  //标题
  sheet_1.SetCellValue(9, 0, "■数据格式");

  sheet_1.SetColWidth(1, 3, 100); //设置列宽
  sheet_1.SetCellValue(9, 1, "小数显示精度：");

  //精度
  sheet_1.SetCellValue(9, 2, 12.23298);
  sheet_1.SetCellFormat("C10", {
    code: "number",
    expression: { precision: "2" },
  });

  //千分位
  sheet_1.SetCellValue(9, 3, "千分位：");
  sheet_1.SetCellValue(9, 4, 5232144.088);
  sheet_1.SetCellFormat(9, 4, {
    code: "number",
    expression: { precision: "1", thousand: true },
  });
  //布尔
  sheet_1.SetCellValue(9, 5, "布尔格式：");
  sheet_1.SetCellValue(9, 6, "1");
  var format_bool1 = {
    code: "bool",
    expression: {
      format: "正确/错误",
    },
  };
  sheet_1.SetCellFormat(9, 6, format_bool1);

  //百分比
  sheet_1.SetCellValue(9, 7, "百分比：");
  var format_bfb = {
    code: "%",
    expression: {
      precision: "1",
    },
  };
  sheet_1.SetCellValue(9, 8, "0.25431");
  sheet_1.SetCellFormat(9, 8, format_bfb);

  //强制文本格式???????????????????????????????????
  sheet_1.SetCellValue(9, 9, "强制文本：");
  sheet_1.SetCellFormat(9, 10, { code: "string" });
  sheet_1.SetCellValue(9, 10, "372901101400");
  sheet_1.SetColWidth(9, 10, 120); //设置列宽

  // //日期格式
  sheet_1.SetCellValue(10, 1, "短日期：");
  sheet_1.SetCellValue(10, 2, "2025-06-11 18:30:21");
  sheet_1.SetCellFormat(10, 2, {
    code: "date",
    expression: "yyyy-M-d",
  });

  sheet_1.SetCellValue(10, 3, "长日期：");
  sheet_1.SetCellValue(10, 4, "2025-06-11 22:30:21");
  sheet_1.SetCellFormat(10, 4, {
    code: "date",
    expression: "yyyy-MM-dd hh:mm:ss",
  });
  sheet_1.SetColWidth(4, 5, 120); //设置列宽

  sheet_1.SetCellValue(10, 5, "中文日期：");
  sheet_1.SetCellValue(10, 6, "2025-06-03 12:30:21");
  sheet_1.SetCellFormat(10, 6, {
    code: "date",
    expression: "yyyy年MM月dd日 HH:mm:ss",
  });
  sheet_1.SetColWidth(6, 6, 150); //设置列宽

  sheet_1.SetCellValue(10, 7, "单元格换行：");
  sheet_1.SetColWidth(7, 8, 100); //设置列宽
  sheet_1.SetCellValue(10, 8, "我是一个很长很长的故事，需要分章节。");
  sheet_1.SetCellStyle(10, 8, { hAlign: "left", wordWrap: 1 });
  sheet_1.SetRowHeight(10, 10, 50); //设置行高

  //批量设置 对齐
  sheet_1.SetCellStyle(["A10", "C10"], {
    hAlign: "center",
  });

  //批量设置对齐
  sheet_1.SetCellStyle(
    ["B10", "D10", "F10", "H10", "J10", "B11", "D11", "F11", "H11"],
    {
      hAlign: "right",
    }
  );

  //#endregion--数据格式--end-

  //#region--单元格类型--start-
  //标题
  sheet_1.SetCellValue(11, 0, "■单元格类型");
  sheet_1.SetCellStyle(11, 0, {
    hAlign: "center",
  });

  //复选框
  sheet_1.SetCellValue(11, 1, "复选框：");
  sheet_1.SetCellStyle(11, 1, { hAlign: "right" });
  var ctype_checkbox1 = {
    code: "checkbox",
    object: {
      title: "是否参加",
    },
  };
  sheet_1.SetCellType(11, 2, ctype_checkbox1);
  sheet_1.SetCellValue(11, 2, 1);

  //按钮
  sheet_1.SetCellValue(11, 3, "按钮：");
  sheet_1.SetCellStyle(11, 3, { hAlign: "right" });
  var ctype_button3 = {
    code: "button",
    object: {
      text: "点我点我！",
      fun: function test(e, data) {
        alert("我是ZCELL自定义按钮触发事件");
      },
    },
  };
  sheet_1.SetCellType(11, 4, ctype_button3);

  //下拉选项
  sheet_1.SetCellValue(11, 5, "下拉选项：");
  sheet_1.SetCellStyle(11, 5, { hAlign: "right" });
  var ctype_drop = {
    code: "dropdown",
    object: {
      source: {
        "001": "Yellow",
        "002": "orange",
        "003": "gray",
        "004": "aYellow",
        "005": "aorange",
        "006": "agray",
      },
    },
  };
  sheet_1.SetCellType(11, 6, ctype_drop);
  sheet_1.SetCellValue(11, 6, "002");

  //下拉选项
  sheet_1.SetCellValue(11, 7, "小按钮：");
  sheet_1.SetCellStyle(11, 7, { hAlign: "right" });

  var ctype_smallbutton = {
    code: "smallbutton",
    object: {
      text: "选择",
      fun: function test(e, data) {
        var word = prompt(
          "这是smallbutton,您可以自定义事件方法，比如输入文字",
          "请输入"
        ); //第一个参数是提示文字，第二个参数是文本框中默认的内容
        if (word) {
          alert("您已输入:" + word); //输出word的格式
          sheet_1.SetCellValue(11, 8, word);
        }
      },
    },
  };
  sheet_1.SetCellType(11, 8, ctype_smallbutton);

  sheet_1.MergeCell(11, 9, 11, 10);
  sheet_1.SetCellValue(11, 9, "所有单元格类型都支持全键盘操作哦！");
  sheet_1.SetCellStyle(11, 9, {
    hAlign: "center",
    backColor: "#FFFF00",
  });

  //批量设置边框，注意合并单元格，要先合并再设置
  sheet_1.SetCellBorder(["J5", "J7", "J12"], {
    borderLeft: { color: "#000000", style: "thin" }, //左边框
    borderRight: { color: "#000000", style: "thin" }, //右边框
    borderTop: { color: "#000000", style: "thin" }, //上边框
    borderBottom: { color: "#000000", style: "thin" }, //下边框
  });

  //#endregion--单元格类型--end-

  //#region--绑定事件--start-
  //标题
  sheet_1.SetCellValue(12, 0, "■支持绑定事件");
  sheet_1.SetCellStyle(12, 0, {
    hAlign: "center",
  });

  //修改触发事件
  sheet_1.SetCellValue(12, 1, "修改我");
  sheet_1.BindEvents(
    "CellValueChangeAfter",
    "B13", //这里直接传入要绑定事件的对象标识可以是单元格（未来也可以是别的对象）
    function (e, data) {
      e_test1(e, data);
    }
  );

  //级联选择触发事件
  var ctype_drop2 = {
    code: "dropdown",
    object: {
      source: {
        "001": "Yellow",
        "002": "orange",
        "003": "gray",
        "004": "请选一个",
      },
    },
  };
  sheet_1.SetCellType(12, 2, ctype_drop2);
  sheet_1.SetCellValue(12, 2, "004");
  //设置触发事件
  sheet_1.BindEvents("CellValueChangeAfter", "C13", function (e, data) {
    e_test2(e, data);
  });

  sheet_1.SetCellType(12, 3, ctype_drop2);
  sheet_1.SetCellValue(12, 3, "004");

  //自定义右键菜单事件支持
  sheet_1.SetCellValue(12, 4, "自定义右键,请右击");

  //#endregion--绑定事件--end-

  //#region--键盘操作--start-
  //标题
  sheet_1.SetCellValue(13, 0, "■支持键盘操作");
  sheet_1.SetCellStyle(13, 0, {
    hAlign: "center",
  });

  sheet_1.SetCellValue(13, 1, "请按Ctl+C");
  sheet_1.SetCellValue(13, 2, "请按Ctl+V");
  sheet_1.SetCellValue(13, 3, "请按回车键");
  sheet_1.SetCellValue(13, 4, "请按上下左右键");
  sheet_1.SetCellValue(13, 5, "请按字符键");
  sheet_1.SetCellValue(13, 6, "请按=键和ESC键测试效果");
  sheet_1.SetCellValue(13, 7, "请按删除键");
  sheet_1.SetCellValue(13, 8, "请按小键盘键");

  //#endregion--键盘操作--end-

  //#region--鼠标操作--start-
  //标题
  sheet_1.SetCellValue(14, 0, "■支持鼠标操作");
  sheet_1.SetCellStyle(14, 0, {
    hAlign: "center",
  });

  sheet_1.SetCellValue(14, 1, "双击编辑");
  sheet_1.SetCellValue(14, 2, "拖动鼠标多选");
  sheet_1.SetCellValue(14, 3, "按Ctl+左键多选");
  sheet_1.SetCellValue(14, 4, "按Shift+左键连选");

  //#endregion--鼠标操作--start-

  //标题
  sheet_1.SetCellValue(15, 0, "■行列操作");
  sheet_1.SetCellStyle(15, 0, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(15, 1, "请到插件上部功能区测试行列操作");
  sheet_1.MergeCell(15, 1, 15, 2);

  //标题
  sheet_1.SetCellValue(16, 0, "■表单操作");
  sheet_1.SetCellStyle(16, 0, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(16, 1, "请到插件上部功能区测试sheet操作");
  sheet_1.MergeCell(16, 1, 16, 2);

  //#region--其他开放API--start-
  //标题
  sheet_1.SetCellValue(17, 0, "■其他开放API");
  sheet_1.SetCellStyle(17, 0, {
    hAlign: "center",
  });

  //只读
  sheet_1.SetCellValue(17, 1, "只读单元格");
  sheet_1.SetCellReadOnly("B18", "1");

  //实时计算
  var bt_ssjs = {
    code: "button",
    object: {
      text: "实时计算",
      fun: function test(e, data) {
        alert("选定数值单元格后，可以在智表下方查看实时计算结果");
      },
    },
  };
  sheet_1.SetCellType(17, 2, bt_ssjs);

  //获取单元格名
  var bt_getname = {
    code: "button",
    object: {
      text: "获取单元格名",
      fun: function test(e, data) {
        alert(sheet_1.GetCellName(17, 3));
      },
    },
  };
  sheet_1.SetCellType(17, 3, bt_getname);

  //获取表格行列数
  var bt_rccount = {
    code: "button",
    object: {
      text: "获取行列数",
      fun: function () {
        var str1 =
          "总行数：" +
          sheet_1.GetRowCount() +
          ",  总列数：" +
          sheet_1.GetColCount();
        alert(str1);
      },
    },
  };
  sheet_1.SetCellType(17, 4, bt_rccount);

  //获取公式串
  var bt_getformul = {
    code: "button",
    object: {
      text: "获取公式串",
      fun: function () {
        var val = sheet_1.GetFormula(6, 2);

        alert("C7公式表达式为：" + val);
      },
    },
  };
  sheet_1.SetCellType(17, 5, bt_getformul);

  //获取当前坐标
  var bt_getrcno = {
    code: "button",
    object: {
      text: "获得坐标",
      fun: function () {
        var str1 =
          "当前行号：" +
          sheet_1.GetCurrentRowNo() +
          ",列号：" +
          sheet_1.GetCurrentColNo();
        alert(str1);
      },
    },
  };
  sheet_1.SetCellType(18, 1, bt_getrcno);

  //获取单元格值
  var bt_getval = {
    code: "button",
    object: {
      text: "获取单元格值",
      fun: function () {
        var val = sheet_1.GetCellValue(9, 6);
        alert("G10单元格值为：" + val);
      },
    },
  };
  sheet_1.SetCellType(18, 2, bt_getval);

  //获取单元格显示值
  var bt_getval2 = {
    code: "button",
    object: {
      text: "单元格显示值",
      fun: function () {
        var val = sheet_1.GetCellDisValue(9, 6);
        alert("G10单元格显示值为：" + val);
      },
    },
  };
  sheet_1.SetCellType(18, 3, bt_getval2);

  //获取行高
  var bt_getrh = {
    code: "button",
    object: {
      text: "获取行高",
      fun: function () {
        var a = sheet_1.GetRowHeight(3);
        alert("第4行高：" + a);
      },
    },
  };
  sheet_1.SetCellType(18, 4, bt_getrh);

  //获取列宽
  var bt_getcolw = {
    code: "button",
    object: {
      text: "获取列宽",
      fun: function () {
        var a = sheet_1.GetColWidth(0);
        alert("A列宽：" + a);
      },
    },
  };
  sheet_1.SetCellType(18, 5, bt_getcolw);

  //#endregion--其他开放API--start-

  //#region--绑定数据--start-
  //标题
  sheet_1.SetCellValue(20, 0, "■绑定数据");
  sheet_1.SetCellStyle(20, 0, {
    hAlign: "center",
  });
  sheet_1.SetCellValue(20, 1, "请到插件上部功能区测试绑定数据");
  sheet_1.MergeCell(20, 1, 20, 2);

  //--------卡片式--------
  sheet_1.SetCellValue(21, 1, "卡片式：");
  sheet_1.SetCellStyle(21, 1, { hAlign: "right" });

  //设置表头 文本和样式
  sheet_1.SetCellValue(22, 2, "姓名：");
  sheet_1.SetCellValue(23, 2, "年龄：");
  sheet_1.SetCellValue(24, 2, "地址：");
  sheet_1.SetCellStyle(22, 2, { hAlign: "right" });
  sheet_1.SetCellStyle(23, 2, { hAlign: "right" });
  sheet_1.SetCellStyle(24, 2, { hAlign: "right" });

  //获取变更数据
  var bt_getchange1 = {
    code: "button",
    object: {
      text: "获取变更数据",
      fun: function test(e, data) {
        let ds1 = sheet_1.GetDataSource("motong");
        if (ds1 == null) {
          alert("指定数据源不存在");
          return;
        }

        let ccs = ds1.GetChangeCells();
        let str = "共修改了" + ccs.length + "项值。";
        for (let index = 0; index < ccs.length; index++) {
          const item = ccs[index];
          str += "数据项：";
          str += item.field;
          str += " 新值：";
          str += item.value;
          str += " 原值：";
          str += item.originalvalue;
          str += " ；";
        }

        alert(str);
      },
    },
  };
  sheet_1.SetCellType(21, 4, bt_getchange1);

  //--------表格式--------
  sheet_1.SetCellValue(21, 5, "表格式：");
  sheet_1.SetCellStyle(21, 5, { hAlign: "right" });

  //新增行
  var bt_getand = {
    code: "button",
    object: {
      text: "新增数据行",
      fun: function test(e, data) {
        let ds1 = sheet_1.GetDataSource("person");
        if (ds1 == null) {
          alert("指定数据源不存在");
          return;
        }

        ds1.AddRow(1, "ASC"); // 支持 ASC 正序增加 在最后新增， DESC 倒序增加 在最前新增
      },
    },
  };
  sheet_1.SetCellType(20, 6, bt_getand);

  //获取插入行
  var bt_getinsert = {
    code: "button",
    object: {
      text: "获取插入行",
      fun: function test(e, data) {
        let ds1 = sheet_1.GetDataSource("person");
        if (ds1 == null) {
          alert("指定数据源不存在");
          return;
        }
        let drows = ds1.GetInsertRows();
        if (drows) {
          let str = "共插入" + drows.length + "行";
          alert(str);
        }
      },
    },
  };
  sheet_1.SetCellType(20, 8, bt_getinsert);

  //获取变更行
  var bt_getchange = {
    code: "button",
    object: {
      text: "获取变更行",
      fun: function test(e, data) {
        let ds1 = sheet_1.GetDataSource("person");
        if (ds1 == null) {
          alert("指定数据源不存在");
          return;
        }
        let drows = ds1.GetChangRows();
        if (drows) {
          let str = "共修改了" + drows.length + "行:序号为";
          for (let i = 0; i < drows.length; i++) {
            str += drows[i].cn;
            str += " , ";

            str += "修个了(" + drows[i].changeCells.length + ")个单元格。";
            let ccs = drows[i].changeCells;
            for (let index = 0; index < ccs.length; index++) {
              const item = ccs[index];
              str += "数据项：";
              str += item.field;
              str += " 新值：";
              str += item.value;
              str += " 原值：";
              str += item.originalvalue;
              str += " ；";
            }
          }
          alert(str);
        }
      },
    },
  };
  sheet_1.SetCellType(20, 9, bt_getchange);

  //获取删除行
  var bt_getdelete = {
    code: "button",
    object: {
      text: "获取删除行",
      fun: function test(e, data) {
        let ds1 = sheet_1.GetDataSource("person");
        if (ds1 == null) {
          alert("指定数据源不存在");
          return;
        }
        let drows = ds1.GetDeleteRows();
        if (drows) {
          let str = "共删除了" + drows.length + "行:序号为";
          for (let i = 0; i < drows.length; i++) {
            str += drows[i].cn;
            str += " ; ";
          }
          alert(str);
        }
      },
    },
  };
  sheet_1.SetCellType(20, 10, bt_getdelete);

  //设置表头 文本和样式
  sheet_1.SetCellValue(21, 6, "序号");
  sheet_1.SetCellValue(21, 7, "书籍");
  sheet_1.SetCellValue(21, 8, "作者");
  sheet_1.SetCellValue(21, 9, "角色");
  sheet_1.SetCellValue(21, 10, "操作");

  //表头样式
  let headstyle1 = {
    hAlign: "center",
    fontBold: 1,
    backColor: "#EEEEEE",
  };

  //批量设置样式
  // 方式1 可以用行列号定位，也可以用单元格名定位
  // sheet_1.SetCellStyle(
  //   [
  //     [21, 6],
  //     [21, 7],
  //     [21, 8],
  //     [21, 9],
  //     [21, 10],
  //   ],
  //   headstyle1
  // );

  //方式2
  sheet_1.SetCellStyle("G22:K22", headstyle1);

  //#endregion--绑定数据--end-

  sheet_1.RecoverPaint(); //恢复绘制1

  // sheet_1.SetColLabText("C", "列名01");

  // //新样式
  // var stylecol = {
  //   backColor: "#bad823ff", //背景色
  // };
  // sheet_1.SetColLabStyle("C", stylecol);

  //追加表格2
  let sheet2 = zcell_1.AppendSheet({
    name: "表格2",
    rowCount: 20,
    colCount: 10,
    activedIndex: 0, //多sheet追加时不激活可提高效率，一般不需要设置，不设置将当前追加的SHEET设置为激活
  });
  //设置表格2值
  sheet2.SetCellValue(0, 0, 1.1);
  sheet2.SetCellValue(1, 0, 2.2);
  sheet2.SetCellValue(0, 1, 3);

  //追加表格3
  let sheet3 = zcell_1.AppendSheet({
    name: "表格3",
    rowCount: 30,
    colCount: 20,
    activedIndex: 0,
  });
  //设置表格3值
  sheet3.SetCellValue(0, 1, 1);

  //设置跨表公式
  sheet_1.SetCellValue(7, 1, "跨表公式");
  sheet_1.SetFormula(7, 2, "sum('表格2'!B1:B3)+'表格3'!B1+SUM(D9:E9)+D8");

  refreshTab(zcell_1);
}

//初始化homesheet
function inithomesheet() {
  let sheetoption = {
    name: "sheet01",
    rowCount: 50,
    colCount: 20,
  };
  sheet_1 = zcell_1.AppendSheet(sheetoption);
}

//自定义函数
function TEST1(a, c) {
  return a + c * 2;
}

//事件触发函数1
function e_test1(e, data) {
  alert(
    "修改前值为：【" +
      data.originalvalue +
      "】 修改后值为:【" +
      data.value +
      "】"
  ); //取得修改前原值
}

//事件触发函数2
function e_test2(e, data) {
  //修改D13的选中值与C13单元格一致
  let s_cell = sheet_1.GetCell("C13");
  let t_cell = sheet_1.GetCell("D13");
  sheet_1.SetCellValue(
    t_cell.row,
    t_cell.col,
    sheet_1.GetCellValue(s_cell.row, s_cell.col)
  );
}

//取消自动计算
function unautocalcu() {
  sheet_1.AllowAutoCalculate = false;

  alert("已取消自动计算，界面公式不再自动计算，请手动调用计算API计算公式");
}

//手工计算公式
function manualcalcu() {
  sheet_1.CalculateSheet();
}

//#endregion 页面加载执行---end----

//#region API测试功能区执行---start----

//#region 行列操作---start----
function hiddenRow() {
  if (!sheet_1.rowList[3].hidden) {
    sheet_1.SetRowHidden(3, 3);
  } else {
    sheet_1.SetRowUnHidden(3, 3);
  }
}
function SetRowH() {
  sheet_1.SetRowHeight(4, 4, 50);
}

function hiddenCol() {
  if (!sheet_1.colList[3].hidden) {
    sheet_1.SetColHidden("D", "E");
  } else {
    sheet_1.SetColUnHidden("D", "E");
  }
}
function SetColW() {
  sheet_1.SetColWidth(4, 5, 100);
}

function insertrow() {
  sheet_1.InsertRow(6, 1);
}

function insertcol() {
  sheet_1.InsertCol(6, 1);
  sheet_1.InsertCol("E", 1);
}

function appendrow() {
  sheet_1.AppendRow(3);
}

function deleterow() {
  let cell = sheet_1.activedCell;
  sheet_1.DeleteRow(cell.row, 1);
}

function appendcol() {
  sheet_1.AppendCol(3);
}

function deletecol() {
  let cell = sheet_1.activedCell;
  sheet_1.DeleteCol(cell.col, 1);
}

function showlab() {
  if (sheet_1.showRowLab == 0) {
    sheet_1.ShowRowLab("1");
    sheet_1.ShowColLab("1");
  } else {
    sheet_1.ShowRowLab("0");
    sheet_1.ShowColLab("0");
  }
}

function setfreeze() {
  sheet_1.SetFreezeTop(3);
  sheet_1.SetFreezeLeft(1);
}
function unsetfreeze() {
  sheet_1.SetFreezeTop(0);
  sheet_1.SetFreezeLeft(0);
}

//#endregion 行列操作---start----

//#region 表单操作---start----

function appendsheet() {
  sheet_1 = zcell_1.AppendSheet(null);
  refreshTab(zcell_1);
}

function cleansheet() {
  zcell_1.DeleteAllSheet();
  refreshTab(zcell_1);
}

function deletesheet() {
  zcell_1.DeleteSheet(0);
  refreshTab(zcell_1);
}

function dissheet(index) {
  alert("请在功能区下方的页签区点击相应SHEET查看切换效果");
}

function getallsheet() {
  let str = "";
  for (let i = 0; i < zcell_1.sheets.length; i++) {
    str += "[";
    str += zcell_1.sheets[i].name;
    str += "]";
  }
  alert(str);
}

//#endregion 表单操作---end----

//#region 其他操作---start----
function getselcells() {
  alert(sheet_1.GetSelCellsJson());
}

//获得单元格自定义属性串
function gettdtag() {
  //设置单元格自定义属性
  var attr1 = '"t1":{"bb"},"t2":{"bb"}';
  sheet_1.SetCellTag("D11", attr1);

  //获取
  var val = sheet_1.GetCellTag("D11");
  alert("自定义属性值为：" + val);
}

//#endregion 其他操作---end----

//#region 绑定数据---start----
//绑定数据--卡片式
function binddata1() {
  var jsondata = { name: "哪吒", age: 15, address: "陈塘关" };
  let option1 = {
    name: "motong",
    type: 0, //0- datacard 卡片式，1是 datatable  表格式
    data: jsondata,
  };
  let ds = sheet_1.GetDataSource("motong");
  if (ds == null) {
    ds = sheet_1.CreatDataSource(option1);
  }

  ds.Mapping("D23", "name"); //单元格名必须大写，插入行列时，绑定关系会随动
  ds.Mapping("D24", "age");
  ds.Mapping("D25", "address");
  sheet_1.BindDataSource(ds);
}

//绑定数据--表格式
function binddata2() {
  var persons = [];
  for (let i = 0; i < 10; i++) {
    let p = {
      cn: (i + 1).toString().padStart(3, "0"),
      book: "西游记",
      auth: "吴承恩",
      name: "徒弟" + (i + 1),
      operate: "", //操作列值可设为空
    };
    persons.push(p);
  }

  let option = {
    name: "person",
    type: 1, //0- datacard 卡片式，1是 datatable  表格式
    data: persons,

    startrow: 22, //  datatable 式需要设置，必须指定，索引从0行开始
    startcol: "G", // datatable 式需要设置，必须指定，索引从A列开始

    //autoBindColumn: true, //datatable 式需要设置 自动绑定列时设置，默认不需要设置
  };
  let ds = sheet_1.GetDataSource("person");
  if (ds == null) {
    ds = sheet_1.CreatDataSource(option);
  }

  //支持指定绑定列和不指定绑定列两种模式，不指定绑定时插件自动逐列绑定
  ds.Mapping("G", "cn"); //列名必须大写，插入行列时，绑定关系会随动
  ds.Mapping("H", "book"); //指定绑定时，可以跳过某列，注意非绑定列样式不往下携带
  ds.Mapping("I", "auth");
  ds.Mapping("J", "name");
  ds.Mapping("K", "operate");

  //#region 设置开始行单元格信息，绑定时自动作为列信息往下携带。
  let colstyle1 = {
    hAlign: "center",
    fontColor: "#FF6666",
  };

  let colstyle2 = {
    hAlign: "center",
    fontColor: "#0000FF",
  };

  let border1 = {
    borderLeft: { color: "#000000", style: "thin" }, //左边框
    borderRight: { color: "#000000", style: "thin" }, //右边框
    borderTop: { color: "#000000", style: "thin" }, //上边框
    borderBottom: { color: "#000000", style: "thin" }, //下边框
  };

  //定义链接按钮类型
  var ctype_link1 = {
    code: "linkbutton",
    object: {
      text: "查看",
      fun: function openurl(e, data) {
        let ds1 = sheet_1.GetDataSource("person");
        let drow = ds1.GetDataRow(data.rowNo);
        let str = "当前行序号：" + drow.cn;
        str += " ; 数据项变更后值为：";
        for (let i = 0; i < drow.changeCells.length; i++) {
          str += drow.changeCells[i].value;
          str += " ; ";
        }
        alert(str);
      },
    },
  };

  //设置列单元格样式 可以对部分列单元格设置部分属性，也可以都不设置。
  // 支持以下设置： cellType 单元格类型； cellStyle 单元格样式； cellBorder 单元格边框;cellFormat 单元格数值格式
  ds.SetColumnInfo("G", { cellStyle: colstyle1, cellBorder: border1 });
  ds.SetColumnInfo("H", { cellStyle: colstyle1 });
  ds.SetColumnInfo("K", { cellType: ctype_link1, cellStyle: colstyle2 });

  //#endregion

  sheet_1.BindDataSource(ds);
}

//获取数据源
function getdata() {
  let dstr = "数据源1:";

  let ds1 = sheet_1.GetDataSource("motong");
  if (ds1 != null) {
    dstr += JSON.stringify(ds1.data);
    dstr += " 。 ";
  }

  let ds = sheet_1.GetDataSource("person");
  if (ds != null) {
    dstr += "数据源2共有:" + ds.data.length + "行。";
  }

  alert(dstr);
}

//清空变更状态，用于提交数据存库后，手工清楚变更状态
function clearchange() {
  let ds1 = sheet_1.GetDataSource("motong");
  if (ds1 != null) {
    ds1.ClearChange();
  }

  let ds = sheet_1.GetDataSource("person");
  if (ds != null) {
    ds.ClearChange();
  }
  alert("清空成功，请重新点击获取变更内容等查看");
}

//新增数据行
function adddatarow() {
  let ds1 = sheet_1.GetDataSource("person");
  if (ds1 != null) {
    ds1.AddRow(2, "asc");
  }
}

//#endregion 绑定数据---end----

//#endregion 功能区测试执行---end----

//#region 性能测试功能区执行---start----

//加载数据测试 1000*50
function loadtest1() {
  //先清空所有sheet
  zcell_1.DeleteAllSheet();

  //追加SHEET
  let sheetoption = {
    name: "性能测试表1",
    rowCount: 1000,
    colCount: 50,
  };
  sheet_1 = zcell_1.AppendSheet(sheetoption);
  refreshTab(zcell_1);

  //准备数据源
  var datas = [];
  for (let i = 0; i < 1000; i++) {
    let item = {};
    for (let j = 0; j < 40; j++) {
      if (j == 0) item[j] = "西游" + (i + 1) + (j + 1);
      else if (j == 1) item[j] = "徒弟" + (i + 1) + (j + 1);
      else item[j] = i + 1 + (j + 1);
    }
    datas.push(item);
  }

  let option2 = {
    name: "data1",
    type: 1, //0- datacard，1是 datatable
    data: datas,
    startrow: 0, //  datatable 式需要设置
    startcol: "A", //  datatable 式需要设置
    autoBindColumn: true,
  };
  let ds = sheet_1.CreatDataSource(option2);

  //定义边框
  let border1 = {
    borderLeft: { color: "#000000", style: "thin" }, //左边框
    borderRight: { color: "#000000", style: "thin" }, //右边框
    borderTop: { color: "#000000", style: "thin" }, //上边框
    borderBottom: { color: "#000000", style: "thin" }, //下边框
  };
  //定义普通按钮类型
  var ctype_button1 = {
    code: "button",
    object: {
      text: "编辑",
      fun: function test(e, data) {
        alert("编辑本行");
      },
    },
  };

  //定义链接按钮类型
  var ctype_link1 = {
    code: "linkbutton",
    object: {
      text: "查看",
      fun: function openurl(e, data) {
        alert("查看当前行");
      },
    },
  };

  //设置列样式
  for (let i = 0; i < 50; i++) {
    if (i == 0)
      ds.SetColumnInfo(sheet_1.ToColname(i), {
        cellType: ctype_button1,
      });
    else if (i == 1)
      ds.SetColumnInfo(sheet_1.ToColname(i), {
        cellType: ctype_link1,
      });
  }

  //开始时间
  var myTime1 = window.performance.now();
  //加载数据
  sheet_1.BindDataSource(ds);
  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost1").html(timecost + "秒");

  //设置边框，这种方式比直接在列样式里设置速度要快。
  sheet_1.SuspendPaint();
  sheet_1.SetRectBorder(0, 0, 1000 - 1, 50 - 1, border1);
  sheet_1.RecoverPaint();
}

//加载数据测试 5000*50
function loadtest2() {
  //先清空所有sheet
  zcell_1.DeleteAllSheet();

  //追加SHEET
  let sheetoption = {
    name: "性能测试表2",
    rowCount: 5000,
    colCount: 50,
  };
  sheet_1 = zcell_1.AppendSheet(sheetoption);
  refreshTab(zcell_1);

  //准备数据源
  var datas = [];
  for (let i = 0; i < 5000; i++) {
    let item = {};
    for (let j = 0; j < 50; j++) {
      if (j == 0) item[j] = "水浒" + (i + 1) + (j + 1);
      else if (j == 1) item[j] = "108将" + (i + 1) + (j + 1);
      else item[j] = i + 1 + (j + 1) * 2;
    }
    datas.push(item);
  }

  let option2 = {
    name: "data1",
    type: 1, //0- datacard，1是 datatable
    data: datas,
    startrow: 0, //  datatable 式需要设置
    startcol: "A", //  datatable 式需要设置
    autoBindColumn: true,
  };
  let ds2 = sheet_1.CreatDataSource(option2);

  //开始时间
  var myTime1 = window.performance.now();
  //加载数据
  sheet_1.BindDataSource(ds2);
  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost1").html(timecost + "秒");
}

//加载数据测试 10000*100
function loadtest3() {
  //先清空所有sheet
  zcell_1.DeleteAllSheet();

  //追加SHEET
  let sheetoption = {
    name: "性能测试表3",
    rowCount: 10000,
    colCount: 100,
  };
  sheet_1 = zcell_1.AppendSheet(sheetoption);
  refreshTab(zcell_1);

  //准备数据源
  var datas = [];
  for (let i = 0; i < 10000; i++) {
    let item = {};
    for (let j = 0; j < 100; j++) {
      if (j == 0) item[j] = "红楼梦" + (i + 1) + (j + 1);
      else if (j == 1) item[j] = "十二钗" + (i + 1) + (j + 1);
      else item[j] = i + 1 + (j + 1) * 3;
    }
    datas.push(item);
  }

  let option2 = {
    name: "data1",
    type: 1, //0- datacard，1是 datatable
    data: datas,
    startrow: 0, //  datatable 式需要设置
    startcol: "A", //  datatable 式需要设置
    autoBindColumn: true,
  };
  let ds2 = sheet_1.CreatDataSource(option2);

  //开始时间
  var myTime1 = window.performance.now();
  //加载数据
  sheet_1.BindDataSource(ds2);
  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost1").html(timecost + "秒");
}

//加载数据测试 50000*100
function loadtest4() {
  //先清空所有sheet
  zcell_1.DeleteAllSheet();

  //追加SHEET
  let sheetoption = {
    name: "性能测试表4",
    rowCount: 50000,
    colCount: 100,
  };
  sheet_1 = zcell_1.AppendSheet(sheetoption);
  refreshTab(zcell_1);

  //准备数据源
  var datas = [];
  for (let i = 0; i < 50000; i++) {
    let item = {};
    for (let j = 0; j < 100; j++) {
      if (j == 0) item[j] = "三国" + (i + 1) + (j + 1);
      else if (j == 1) item[j] = "五虎将" + (i + 1) + (j + 1);
      else item[j] = i + 1 + (j + 1) * 4 + 0.1;
    }
    datas.push(item);
  }

  let option2 = {
    name: "data1",
    type: 1, //0- datacard，1是 datatable
    data: datas,
    startrow: 0, //  datatable 式需要设置
    startcol: "A", //  datatable 式需要设置
    autoBindColumn: true,
  };
  let ds2 = sheet_1.CreatDataSource(option2);

  let colstyle1 = {
    hAlign: "center",
  };
  //定义边框
  let border1 = {
    borderLeft: { color: "#000000", style: "thin" }, //左边框
    borderRight: { color: "#000000", style: "thin" }, //右边框
    borderTop: { color: "#000000", style: "thin" }, //上边框
    borderBottom: { color: "#000000", style: "thin" }, //下边框
  };

  //开始时间
  var myTime1 = window.performance.now();
  //加载数据
  sheet_1.BindDataSource(ds2);

  //设置边框，这种方式比直接在列样式里设置速度要快。
  // sheet_1.SuspendPaint();
  // sheet_1.SetRectBorder(0, 0, 50000 - 1, 100 - 1, border1);
  // sheet_1.RecoverPaint();

  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost1").html(timecost + "秒");
}

//加载待排序数据
let isloadsortdata = false; //是否加载待排序数据
function loadsortdata() {
  //先清空所有sheet
  zcell_1.DeleteAllSheet();

  //追加SHEET
  let sheetoption = {
    name: "排序测试表1",
    rowCount: 100,
    colCount: 10,
  };
  sheet_1 = zcell_1.AppendSheet(sheetoption);
  refreshTab(zcell_1);

  //准备数据源
  var datas = [];
  // var datas = [
  //   { rowno: 3, person: "徒弟3", lableval: 3 },
  //   { rowno: 1, person: "徒弟1", lableval: 1 },
  //   { rowno: 2, person: "徒弟2", lableval: 2 },
  // ];
  for (let i = 0; i < 100; i++) {
    let randv = getRandomInt(1, 4);
    let sv;
    if (randv == "1") sv = "甲等";
    else if (randv == "2") sv = "乙等";
    else if (randv == "3") sv = "丙等";
    else if (randv == "4") sv = "丁等";

    let item = {
      rowno: "行号" + i,
      person: "徒弟" + getRandomInt(1, 4),
      status: sv,
      lableval: i * 2 + 1,
      lableval2: i * 2 + 2,
      lableval3: i * 2 + 3,
      lableval4: i * 2 + 4,
      lableval5: i * 2 + 5,
    };

    datas.push(item);
  }

  let option2 = {
    name: "data1",
    type: 1, //0- datacard，1是 datatable
    data: datas,
    startrow: 0, //  datatable 式需要设置
    startcol: "A", //  datatable 式需要设置
    autoBindColumn: true,
  };
  let ds = sheet_1.CreatDataSource(option2);

  //开始时间
  var myTime1 = window.performance.now();
  //加载数据
  sheet_1.BindDataSource(ds);
  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost1").html(timecost + "秒");

  isloadsortdata = true;
}

//排序测试
function sorttest() {
  if (isloadsortdata == false) {
    alert("请先执行“准备排序过滤数据”");
    return;
  }
  //排序参数设置
  let option = {
    sortinfo: [
      {
        sortindex: "B", //排序列号，必须大写
        sortorder: "asc", //支持 asc 和 desc
      },
      {
        sortindex: "C",
        sortorder: "asc",
        sortfun: mysortfun, //自定义排序函数
      },
      {
        sortindex: "D",
        sortorder: "desc",
      },
    ],
  };

  //开始时间
  var myTime1 = window.performance.now();

  //执行排序方法
  sheet_1.SortArea(0, 0, 99, 3, option);

  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost1").html(timecost + "秒");
}

//自定义排序函数
function mysortfun(a, b) {
  let datas = ["甲等", "乙等", "丙等", "丁等"];
  let indexa = datas.indexOf(a);
  let indexb = datas.indexOf(b);
  return indexa - indexb;
}

//筛选过滤
function filtertest() {
  if (isloadsortdata == false) {
    alert("请先执行“准备排序过滤数据”");
    return;
  }

  //设置筛选区域
  sheet_1.SetFilterArea(0, 0, 99, 3);
}

//筛选函数过滤
function filterfuntest() {
  if (isloadsortdata == false) {
    alert("请先执行“准备排序过滤数据”");
    return;
  }

  //自定义某列过滤函数，否则不需要设置，为null即可
  let option = {
    colinfo: [
      {
        filterindex: "D",
        filterby: "fun", //指明该列过滤依据是函数自定义函数型
        filterfun: function (sheetobj, row, col) {
          //注意自定义函数 参数是固定的，包括工作表对象和单元格行列索引，且必须返回布尔型结果
          //获取单元格显示值
          let disval = sheetobj.GetCellDisValue(row, col);
          //计算逻辑根据情况自定定义即可
          if (disval > 50 && disval < 120 && disval > 3.14 * 20) {
            return true;
          }
          return false;
        },
      },
    ],
  };
  //设置筛选区域，指定自定义参数，插件不会初始化过滤器窗口，需要手工触发筛选动作
  sheet_1.SetFilterArea(0, 0, 99, 3, option);

  //触发筛选
  sheet_1.FilterArea("D"); //指定自定义列参数中的某一列作为筛选依据列
}

//生成随机数
function getRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

//#endregion 性能测试页签执行---end----

//#region 导入导出功能区执行---start----
//加载远程文件
function loadjson() {
  //开始时间
  var myTime1 = window.performance.now();

  var option2 = {
    opentype: "remote",
    openfile: "./demo/zcell模板.zjs", //打开远程文件路径
    callbackfun: function () {
      openjson_callback(myTime1);
    }, //回调函数
  };

  zcell_1.OpenFile(option2);
}

//回调函数
function openjson_callback(myTime1) {
  //结束时间
  var myTime2 = window.performance.now();

  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost2").html(timecost + "秒");

  refreshTab(zcell_1);
}

//保存文件
function savejson() {
  var option = {
    filename: "zcell模板", //文件名字，不能为空
  };

  //开始时间
  var myTime1 = window.performance.now();
  //执行操作
  var jsstr = zcell_1.SaveFile(option);
  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost2").html(timecost + "秒");
}

//打开文件
function openjson() {
  var fileinput = document.createElement("input");
  fileinput.type = "file";
  fileinput.accept = ".zjs";
  fileinput.onchange = (e) => {
    var file = e.target.files[0];
    //开始时间
    var myTime1 = window.performance.now();

    var Option2 = {
      opentype: "local",
      openfile: file, //打开文件对象
      callbackfun: function () {
        openjson_callback(myTime1);
      }, //回调函数
      // impData: false, // 是否包含单元格值，默认true
    };

    zcell_1.OpenFile(Option2);
  };

  fileinput.click();
}

//导出EXCLE
function extest() {
  //开始时间
  var myTime1 = window.performance.now();

  var expoption = {
    filename: "导出test", //文件名字，不能为空
    // expindex: 0, //导出表单索引，默认 -1为全部
    // expstyle: false, //导出样式 默认 true
    // expformula: false, //导出公式 默认 true
    // expfreeze: false, //导出冻结行列 默认 true
  };
  zcell_1.ExportExcel(expoption);

  //结束时间
  var myTime2 = window.performance.now();
  let timecost = (myTime2 - myTime1) / 1000;
  $("#timecost2").html(timecost + "秒");
}

//导入excel
function imptest() {
  var input = document.createElement("input");
  input.type = "file";
  input.onchange = (e) => {
    var file = e.target.files[0];
    //开始时间
    var myTime1 = window.performance.now();

    var impoption = {
      impfile: file, //导入文件
      callbackfun: function () {
        openjson_callback(myTime1);
      }, //回调函数
      // impstyle: false, //导入样式 默认 true
      // impformula: false, //导入公式 默认 true
      // impfreeze: false, //导入冻结行列 默认 true
    };

    zcell_1.ImportExcel(impoption);
  };

  input.click();
}

//#endregion 导入导出功能区执行---end----

//#region 多实例功能区执行---start----

// //初始化实例2
function initzcell2() {
  var options = {
    container: document.getElementById("zcell-container2"),
  };

  zcell_2 = new ZCell.WorkBook(options);

  //追加表格21
  let sheet21 = zcell_2.AppendSheet({
    name: "sheet21",
    rowCount: 50,
    colCount: 20,
  });

  //设置单元格文本
  sheet21.SetCellValue(2, 0, "下面请体验：");
  sheet21.SetColWidth(0, 0, 120); //设置列宽
  //设置样式
  sheet21.SetCellStyle(2, 0, {
    backColor: "#FFFF00",
    hAlign: "center",
    fontBold: 1, //字体粗细 1为设置，0为正常
    fontItalic: 1, //斜体 1为设置，0为正常
  });

  //标题
  sheet21.SetCellValue(3, 0, "■边框");
  sheet21.SetCellStyle(3, 0, {
    hAlign: "center",
    textdirec: 1, // 0 横向 1纵向  2倾斜
  });
  sheet21.SetRowHeight(3, 3, 40); //设置行高

  //设置边框
  sheet21.SetCellBorder(3, 1, {
    borderLeft: { color: "#000000", style: "thin" }, //左边框
    borderRight: { color: "#FF0000", style: "thin" }, //右边框
    borderTop: { color: "#FF0000", style: "thin" }, //上边框
    borderBottom: { color: "#000000", style: "thin" }, //下边框
  });

  //标题
  sheet21.SetCellValue(4, 0, "■合并单元格");
  sheet21.SetCellStyle(4, 0, {
    hAlign: "center",
    textdirec: 2, // 0 横向 1纵向  2倾斜
    textRatote: 20, // 文字倾斜角度

    fontUnderline: 1, //下划线 1为设置，0为正常
  });
  sheet21.MergeCell(4, 0, 5, 0);

  //公式
  sheet21.SetCellValue(7, 3, "300");
  sheet21.SetCellValue(8, 3, "600");
  sheet21.SetFormula(6, 3, "D8+D9");

  //精度
  sheet21.SetCellValue(9, 2, 12.23298);
  sheet21.SetCellFormat(9, 2, {
    code: "number",
    expression: { precision: "2" },
  });

  //下拉选项
  sheet21.SetCellValue(11, 2, "下拉选项：");
  sheet21.SetCellStyle(11, 2, { hAlign: "right" });
  var ctype_drop = {
    code: "dropdown",
    object: {
      source: {
        "001": "Yellow",
        "002": "orange",
        "003": "gray",
        "004": "aYellow",
        "005": "aorange",
        "006": "agray",
      },
    },
  };
  sheet21.SetCellType(11, 3, ctype_drop);
  sheet21.SetCellValue(11, 3, "002");

  //只读
  sheet21.SetCellValue(13, 1, "只读单元格");
  sheet21.SetCellReadOnly(13, 1, "1");
}

//同步实例内容
function synczcell() {
  //左边实例表格
  let sheet21 = zcell_2.GetSheet(0);

  //右边实例表格
  let sheet31 = zcell_3.GetSheet(0);

  //设置单元格文本
  sheet31.SetCellValue(2, 0, sheet21.GetCellValue(2, 0));
  sheet31.SetColWidth(0, 0, sheet21.GetColWidth(0)); //设置列宽

  //设置样式
  sheet31.SetCellStyle("A3", sheet21.GetCellStyle("A3"));

  //标题
  sheet31.SetCellValue(3, 0, sheet21.GetCellValue(3, 0));
  sheet31.SetCellStyle(3, 0, sheet21.GetCellStyle(3, 0));
  sheet31.SetRowHeight(3, 3, sheet21.GetRowHeight(3)); //设置行高

  //设置边框
  sheet31.SetCellBorder(3, 1, sheet21.GetCellBorder("B4"));

  //标题
  sheet31.SetCellValue(4, 0, sheet21.GetCellValue(4, 0));
  sheet31.SetCellStyle(4, 0, sheet21.GetCellStyle(4, 0));

  //设置合并单元格
  let rowspan1 = sheet21.GetCellRowspan("A5");
  let colspan1 = sheet21.GetCellColspan("A5");
  sheet31.MergeCell(4, 0, 4 + rowspan1 - 1, 0 + colspan1 - 1);

  //公式
  sheet31.SetCellValue(7, 3, sheet21.GetCellValue(7, 3));
  sheet31.SetCellValue(8, 3, sheet21.GetCellValue(8, 3));
  sheet31.SetFormula(6, 3, sheet21.GetFormula(6, 3));

  //精度
  sheet31.SetCellValue(9, 2, sheet21.GetCellValue(9, 2));
  sheet31.SetCellFormat(9, 2, sheet21.GetCellFormat(9, 2));

  //下拉选项
  sheet31.SetCellValue(11, 2, sheet21.GetCellValue(11, 2));
  sheet31.SetCellStyle(11, 2, sheet21.GetCellStyle(11, 2));
  sheet31.SetCellType("D12", sheet21.GetCellType("D12"));
  sheet31.SetCellValue(11, 3, sheet21.GetCellValue(11, 3));

  //只读
  sheet31.SetCellValue(13, 1, sheet21.GetCellValue(13, 1));
  sheet31.SetCellReadOnly(13, 1, sheet21.GetCellReadOnly(13, 1));
}

//初始化实例3
function initzcell3() {
  var options = {
    container: document.getElementById("zcell-container3"),
  };

  zcell_3 = new ZCell.WorkBook(options);

  //追加表格21
  let sheet31 = zcell_3.AppendSheet({
    name: "sheet31",
    rowCount: 100,
    colCount: 25,
  });
}

//#endregion 多实例功能区执行---end----

//#region 支持公式函数清单执行---start----

//加载公式清单
function loadgsqd() {
  var option2 = {
    opentype: "remote",
    openfile: "./demo/公式函数清单.zjs", //打开远程文件路径
    callbackfun: function () {
      refreshTab(zcell_1);
    }, //回调函数
  };

  zcell_1.OpenFile(option2);
}

//#endregion 支持公式函数清单执行---start----

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//刷新显示页签
/** 头部页签切换功能---start */
document.addEventListener("DOMContentLoaded", function () {
  const tabButtons = document.querySelectorAll(".tab-button");
  const tabPanes = document.querySelectorAll(".tab-pane");

  tabButtons.forEach((button) => {
    button.addEventListener("click", function () {
      // Remove active class from all buttons and panes
      tabButtons.forEach((btn) => btn.classList.remove("active"));
      tabPanes.forEach((pane) => pane.classList.remove("active"));

      // Add active class to the clicked button and corresponding pane
      this.classList.add("active");
      const tabId = this.getAttribute("data-tab");
      document.getElementById(tabId).classList.add("active");

      //先设置默认值
      $("#tt1").css({
        display: "block",
      });
      $("#tt2").css({
        display: "none",
      });

      $(".tab-head").css({
        display: "block",
      });

      //根据不同页签，默认初始化
      if (tabId == "home") {
        //API测试初始化
        initAPItest();
      } else if (tabId == "performance") {
        //先清空所有sheet
        zcell_1.DeleteAllSheet();
        refreshTab(zcell_1);
      } else if (tabId == "multiple") {
        //先设置显示
        $("#tt1").css({
          display: "none",
        });
        $("#tt2").css({
          display: "block",
        });

        $(".tab-head").css({
          display: "none",
        });

        //初始化
        if (zcell_2 == undefined) initzcell2();
        if (zcell_3 == undefined) initzcell3();
      } else if (tabId == "formulaList") {
        zcell_1.DeleteAllSheet();
        loadgsqd();
      }
    });
  });
});
/** 头部页签切换功能---end */
